<?php
session_start();
include_once 'connection.php';

// Consulta SQL para buscar todos os eventos
$sql = "SELECT id, title, descricao, color, start, end, observacao, id_local, realizada, justificativa FROM events";
try {
    $req = $pdo->prepare($sql);
    $req->execute();
    $events = $req->fetchAll();
} catch (PDOException $e) {
    echo "Erro ao buscar eventos: " . $e->getMessage();
    exit();
}

// Função para formatar os eventos por data
$eventsByDate = [];
foreach ($events as $event) {
    $date = date('Y-m-d', strtotime($event['start']));
    $eventsByDate[$date][] = $event; // Agrupa eventos pela data
}

// Configuração do mês atual
$month = date('m');
$year = date('Y');

$firstDayOfMonth = new DateTime("$year-$month-01");
$lastDayOfMonth = new DateTime($firstDayOfMonth->format('Y-m-t'));
$daysInMonth = $lastDayOfMonth->format('d');
$firstWeekday = $firstDayOfMonth->format('N'); // 1 (segunda) a 7 (domingo)

$calendars = [[
    'month' => $month,
    'year' => $year,
    'daysInMonth' => $daysInMonth,
    'firstWeekday' => $firstWeekday,
    'eventsByDate' => $eventsByDate
]];

$monthNames = [
    'January' => 'Janeiro',
    'February' => 'Fevereiro',
    'March' => 'Março',
    'April' => 'Abril',
    'May' => 'Maio',
    'June' => 'Junho',
    'July' => 'Julho',
    'August' => 'Agosto',
    'September' => 'Setembro',
    'October' => 'Outubro',
    'November' => 'Novembro',
    'December' => 'Dezembro'
];

// Obter dados dos próximos 3 meses
$nextMonths = [];
for ($i = 1; $i <= 3; $i++) {
    $nextMonthDate = new DateTime("$year-$month-01");
    $nextMonthDate->modify("+$i month");
    $nextMonths[] = [
        'month' => $nextMonthDate->format('m'),
        'year' => $nextMonthDate->format('Y'),
        'name' => $monthNames[$nextMonthDate->format('F')]
    ];
}

$aniversariantesSql = "SELECT
    aniversariantes.pg,
    aniversariantes.nome,
    aniversariantes.data
FROM
    aniversariantes
ORDER BY
    STR_TO_DATE(aniversariantes.`data`, '%d/%m') ASC;";

$reqAniversariantes = $pdo->prepare($aniversariantesSql);
$reqAniversariantes->execute();
$aniversariantes = $reqAniversariantes->fetchAll();

// Consulta para afastamentos
// Consulta para afastamentos
$afastamentosSql = "SELECT pg, nome, afast1, afast2, afast3 FROM aniversariantes WHERE afast1 IS NOT NULL OR afast2 IS NOT NULL OR afast3 IS NOT NULL";
$reqAfastamentos = $pdo->prepare($afastamentosSql);
$reqAfastamentos->execute();
$afastamentos = $reqAfastamentos->fetchAll();

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendário de Eventos</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <style>
    .event-title {
    border-radius: 4px; /* Adiciona borda arredondada */
    color: #fff; /* Altera a cor do texto para branco */
}
    </style>
</head>
<body>
<?php require 'nav.php'; ?>
<?php foreach ($calendars as $calendar): ?>
    <div class="calendar-month my-4">
        <div class="month-header text-center">
            <h2><?php echo $monthNames[date('F', mktime(0, 0, 0, $calendar['month'], 10))] . ' ' . $calendar['year']; ?></h2>
        </div>

        <!-- Dias da semana -->
        <div class="calendar-weekdays d-flex text-center fw-bold">
            <div class="weekday flex-fill">Segunda</div>
            <div class="weekday flex-fill">Terça</div>
            <div class="weekday flex-fill">Quarta</div>
            <div class="weekday flex-fill">Quinta</div>
            <div class="weekday flex-fill">Sexta</div>
            <div class="weekday flex-fill">Sábado</div>
            <div class="weekday flex-fill">Domingo</div>
        </div>

        <!-- Dias do mês -->
        <div class="calendar-days d-grid" style="grid-template-columns: repeat(7, 1fr); gap: 0px;">
          <?php
// Calcula o número de células necessário baseado no primeiro dia da semana e dias no mês
$totalDays = $calendar['daysInMonth'] + ($calendar['firstWeekday'] - 1);
$totalWeeks = ceil($totalDays / 7);
$totalCells = $totalWeeks * 7;

$currentDay = 1;
for ($cell = 1; $cell <= $totalCells; $cell++) {
    $isEmptyCell = false;

    if ($cell < $calendar['firstWeekday']) {
        $isEmptyCell = true;
    }

    if ($currentDay > $calendar['daysInMonth']) {
        $isEmptyCell = true;
    }

    echo '<div class="calendar-day border rounded p-2 bg-light">';

    if (!$isEmptyCell) {
        echo "<div class='day-title mb-2'><strong>$currentDay</strong></div>";

        $currentDate = "{$calendar['year']}-" . str_pad($calendar['month'], 2, '0', STR_PAD_LEFT) . "-" . str_pad($currentDay, 2, '0', STR_PAD_LEFT);

        if (isset($calendar['eventsByDate'][$currentDate])) {
            foreach ($calendar['eventsByDate'][$currentDate] as $event) {
                echo "<button class='event-title btn btn-light btn-sm w-100 mb-1' style='background-color: " . $event['color'] . ";' data-bs-toggle='modal' data-bs-target='#eventModal'
                    data-id='" . $event['id'] . "'
                    data-title='" . $event['title'] . "'
                    data-descricao='" . $event['descricao'] . "'
                    data-color='" . $event['color'] . "'
                    data-start='" . $event['start'] . "'
                    data-end='" . $event['end'] . "'
                    data-observacao='" . $event['observacao'] . "'
                    data-local='" . $event['id_local'] . "'
                    data-realizada='" . $event['realizada'] . "'
                    data-justificativa='" . $event['justificativa'] . "'>
                    " . $event['title'] . "</button>";
            }
        }

        $currentDay++;
    }

    echo '</div>'; // .calendar-day
}
?>

        </div>
    </div>
<?php endforeach; ?>

<style>
    .equal-width-table td,
    .equal-width-table th {
        width: calc(100% / <?php echo count($nextMonths) + 3; ?>); /* divide igualmente */
        word-wrap: break-word;
        vertical-align: top;
    }
</style>

<div class="container-fluid px-0"> <!-- Remove padding lateral -->
    <table class="table table-bordered table-sm equal-width-table w-100">
        <thead class="thead-light">
            <tr>
                <?php foreach ($nextMonths as $nextMonth): ?>
                    <th><?php echo $nextMonth['name']; ?></th>
                <?php endforeach; ?>
                <th>Aniversariantes</th>
                <th>Afastamentos</th>
                <th>Equipamentos</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Agrupar eventos por mês
            $eventsByMonth = [];
            foreach ($events as $event) {
                $eventMonth = date('m', strtotime($event['start']));
                if (!isset($eventsByMonth[$eventMonth])) {
                    $eventsByMonth[$eventMonth] = [];
                }
                $eventsByMonth[$eventMonth][] = $event;
            }
            ?>
            <tr>
                <?php foreach ($nextMonths as $nextMonth): ?>
                    <td>
                        <?php
                        $monthKey = str_pad($nextMonth['month'], 2, '0', STR_PAD_LEFT);
                        if (!empty($eventsByMonth[$monthKey])) {
                            foreach ($eventsByMonth[$monthKey] as $event) {
                                echo "<button class='event-title btn btn-light btn-sm w-100 mb-1' style='background-color: " . $event['color'] . ";'
                                    data-bs-toggle='modal' data-bs-target='#eventModal'
                                    data-id='" . $event['id'] . "'
                                    data-title='" . $event['title'] . "'
                                    data-descricao='" . $event['descricao'] . "'
                                    data-color='" . $event['color'] . "'
                                    data-start='" . $event['start'] . "'
                                    data-end='" . $event['end'] . "'
                                    data-observacao='" . $event['observacao'] . "'>
                                    " . $event['title'] . " - " . date('d', strtotime($event['start'])) . "
                                </button>";
                            }
                        } else {
                            echo "<button class='btn btn-light btn-sm w-100' disabled>Nenhum evento</button>";
                        }
                        ?>
                    </td>
                <?php endforeach; ?>
                <td>
                    <ul class="list-unstyled">
                        <?php foreach ($aniversariantes as $aniversariante): ?>
                            <li><?php echo $aniversariante['pg'] . ' - ' . $aniversariante['nome'] . ' - ' . $aniversariante['data']; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td>
                    <ul class="list-unstyled">
                        <?php foreach ($afastamentos as $afastamento): ?>
                            <li><?php echo $afastamento['pg'] . ' - ' . $afastamento['nome'] . ' - ' . $afastamento['afast1'] . ' - ' . $afastamento['afast2'] . ' - ' . $afastamento['afast3']; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td>


                  <?php
                  // Consulta
$sql = "
    SELECT
        equipamentos.id AS equip_id,
        equipamentos.equipamento,
        equipamentos.saida,
        equipamentos.entrada,
        equipamentos.responsavel,
        equipamentos.missao,
        equipamentos.observacao AS observacao_equip,
        desc_equip.id AS desc_id,
        desc_equip.numpat,
        desc_equip.numero_controle,
        desc_equip.descricao,
        desc_equip.carga,
        desc_equip.observacao AS observacao_desc,
        desc_equip.ativo
    FROM
        equipamentos
    INNER JOIN
        desc_equip ON equipamentos.equipamento = desc_equip.id
    ORDER BY
        equipamentos.saida DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute();
$equipamentos = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($equipamentos as $row): ?>
  <button type="button"
          class="btn btn-danger mb-2"
          data-bs-toggle="modal"
          data-bs-target="#equipModal"
          data-id="<?php echo $row['equip_id']; ?>"
          data-descricao="<?php echo $row['descricao']; ?>"
          data-saida="<?php echo $row['saida']; ?>"
          data-entrada="<?php echo $row['entrada']; ?>"
          data-responsavel="<?php echo $row['responsavel']; ?>"
          data-missao="<?php echo $row['missao']; ?>"
          data-observacao="<?php echo $row['observacao_equip']; ?>"
          data-patrimonio="<?php echo $row['numpat']; ?>"
          data-controle="<?php echo $row['numero_controle']; ?>"
          data-carga="<?php echo $row['carga']; ?>"
          data-ativo="<?php echo $row['ativo']; ?>">
      <?php echo $row['descricao'] . ' - ' .$row['saida']; ?>
  </button>
<?php endforeach; ?>


                </td>
            </tr>
        </tbody>
    </table>
</div>


<div class="modal fade" id="equipModal" tabindex="-1" aria-labelledby="equipModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="equipModalLabel">Detalhes do Equipamento</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <p><strong>Descrição:</strong> <span id="modalDescricao"></span></p>
        <p><strong>Saída:</strong> <span id="modalSaida"></span></p>
        <p><strong>Entrada:</strong> <span id="modalEntrada"></span></p>
        <p><strong>Responsável:</strong> <span id="modalResponsavel"></span></p>
        <p><strong>Missão:</strong> <span id="modalMissao"></span></p>
        <p><strong>Observação:</strong> <span id="modalObservacao"></span></p>
        <hr>
        <p><strong>Patrimônio:</strong> <span id="modalPatrimonio"></span></p>
        <p><strong>Controle:</strong> <span id="modalControle"></span></p>
        <p><strong>Carga:</strong> <span id="modalCarga"></span></p>
        <p><strong>Ativo:</strong> <span id="modalAtivo"></span></p>
      </div>
    </div>
  </div>
</div>


<!-- Modal -->
<div class="modal fade" id="eventModal" tabindex="-1" aria-labelledby="eventModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eventModalLabel">Detalhes do Evento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h5 id="modalTitle"></h5>
                <p id="modalDescricao"></p>
                <ul>
                    <li><strong>Início:</strong> <span id="modalStart"></span></li>
                    <li><strong>Fim:</strong> <span id="modalEnd"></span></li>
                    <li><strong>Observação:</strong> <span id="modalObservacao"></span></li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script src="js/jquery-3.5.1.min.js"></script>
<script src="js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
// Preencher o modal com detalhes do evento
$('#eventModal').on('show.bs.modal', function(event) {
    var button = $(event.relatedTarget); // Botão que abriu o modal
    var title = button.data('title');
    var descricao = button.data('descricao');
    var id = button.data('id');
    var start = button.data('start');
    var end = button.data('end');
    var observacao = button.data('observacao');

    // Atualiza o conteúdo do modal
    var modal = $(this);
    modal.find('#modalTitle').text(title);
    modal.find('#modalDescricao').text(descricao);
    modal.find('#modalStart').text(new Date(start).toLocaleString('pt-BR', { hour: '2-digit', minute: '2-digit' }) + ' - ' + new Date(start).toLocaleDateString('pt-BR'));
    modal.find('#modalEnd').text(new Date(end).toLocaleString('pt-BR', { hour: '2-digit', minute: '2-digit' }) + ' - ' + new Date(end).toLocaleDateString('pt-BR'));
    modal.find('#modalObservacao').text(observacao);
});
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  var equipModal = document.getElementById('equipModal');
  equipModal.addEventListener('show.bs.modal', function (event) {
    var button = event.relatedTarget;

    document.getElementById('modalDescricao').textContent = button.getAttribute('data-descricao');
    document.getElementById('modalSaida').textContent = button.getAttribute('data-saida');
    document.getElementById('modalEntrada').textContent = button.getAttribute('data-entrada');
    document.getElementById('modalResponsavel').textContent = button.getAttribute('data-responsavel');
    document.getElementById('modalMissao').textContent = button.getAttribute('data-missao');
    document.getElementById('modalObservacao').textContent = button.getAttribute('data-observacao');
    document.getElementById('modalPatrimonio').textContent = button.getAttribute('data-patrimonio');
    document.getElementById('modalControle').textContent = button.getAttribute('data-controle');
    document.getElementById('modalCarga').textContent = button.getAttribute('data-carga');
    document.getElementById('modalAtivo').textContent = button.getAttribute('data-ativo') == 1 ? 'Sim' : 'Não';
  });
});
</script>


</body>
</html>
