<?php
session_start();
include_once 'connection.php';

// Função para buscar todos os equipamentos
function fetchEquipamentos($pdo) {
    $sql = "SELECT * FROM desc_equip";
    $req = $pdo->prepare($sql);
    $req->execute();
    return $req->fetchAll(PDO::FETCH_ASSOC);
}

$equipamentos = fetchEquipamentos($pdo);

// Lógica para inserir um novo equipamento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add'])) {
    $numpat = $_POST['numpat'];
    $numeroControle = $_POST['numeroControle'];
    $descricao = $_POST['descricao'];
    $carga = $_POST['carga'];
    $observacao = $_POST['observacao'];

    $sql = "INSERT INTO desc_equip (numpat, numero_controle, descricao, carga, observacao) VALUES (?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$numpat, $numeroControle, $descricao, $carga, $observacao]);
    header("Location: equipamentos.php");
}

// Lógica para editar um equipamento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit'])) {
    $id = $_POST['id'];
    $numpat = $_POST['numpat'];
    $numeroControle = $_POST['numeroControle'];
    $descricao = $_POST['descricao'];
    $carga = $_POST['carga'];
    $observacao = $_POST['observacao'];

    $sql = "UPDATE desc_equip SET numpat = ?, numero_controle = ?, descricao = ?, carga = ?, observacao = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$numpat, $numeroControle, $descricao, $carga, $observacao, $id]);
    header("Location: equipamentos.php");
}

// Lógica para ativar ou desativar um equipamento
if (isset($_GET['toggle'])) {
    $id = $_GET['toggle'];
    $status = $_GET['status']; // 0 ou 1

    $sql = "UPDATE desc_equip SET observacao = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$status, $id]);
    header("Location: equipamentos.php"); // Redireciona após a ação
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Equipamentos</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Gestão de Equipamentos TI</h2>

    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addModal">Adicionar Equipamento</button>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Número de Patrimônio</th>
                <th>Número de Controle</th>
                <th>Descrição</th>
                <th>Carga</th>
                <th>Observação</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($equipamentos as $equipamento): ?>
            <tr>
                <td><?php echo $equipamento['id']; ?></td>
                <td><?php echo $equipamento['numpat']; ?></td>
                <td><?php echo $equipamento['numero_controle']; ?></td>
                <td><?php echo $equipamento['descricao']; ?></td>
                <td><?php echo $equipamento['carga']; ?></td>
                <td><?php echo $equipamento['observacao']; ?></td>
                <td>
                    <button class="btn btn-warning btn-sm edit-btn" data-bs-toggle="modal" data-bs-target="#editModal" data-id="<?php echo $equipamento['id']; ?>" data-numpat="<?php echo $equipamento['numpat']; ?>" data-numerocontrole="<?php echo $equipamento['numero_controle']; ?>" data-descricao="<?php echo $equipamento['descricao']; ?>" data-carga="<?php echo $equipamento['carga']; ?>" data-observacao="<?php echo $equipamento['observacao']; ?>">Editar</button>

    <?php
    // Verifica se o equipamento está ativo ou inativo
    $isActive = $equipamento['observacao'] == 1; // Supondo que 1 significa ativo

    // Define o texto e a classe do botão com base no estado do equipamento
    $buttonText = $isActive ? 'Ativar' : 'Desativar';
    $buttonClass = $isActive ? 'btn-success' : 'btn-danger';
    $newStatus = $isActive ? 0 : 1; // 0 para inativar, 1 para ativar

    echo "<a href='?toggle={$equipamento['id']}&status={$newStatus}' class='btn {$buttonClass} btn-sm'>{$buttonText}</a>";
    ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Modal Adicionar -->
<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addModalLabel">Adicionar Equipamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="numpat" class="form-label">Número de Patrimônio</label>
                        <input type="text" class="form-control" name="numpat" required>
                    </div>
                    <div class="mb-3">
                        <label for="numeroControle" class="form-label">Número de Controle</label>
                        <input type="text" class="form-control" name="numeroControle" required>
                    </div>
                    <div class="mb-3">
                        <label for="descricao" class="form-label">Descrição</label>
                        <input type="text" class="form-control" name="descricao" required>
                    </div>
                    <div class="mb-3">
                        <label for="carga" class="form-label">Carga</label>
                        <input type="text" class="form-control" name="carga" required>
                    </div>
                    <div class="mb-3">
                        <label for="observacao" class="form-label">Observação</label>
                        <textarea class="form-control" name="observacao"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" name="add" class="btn btn-primary">Adicionar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Editar -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Editar Equipamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit-id">
                    <div class="mb-3">
                        <label for="edit-numpat" class="form-label">Número de Patrimônio</label>
                        <input type="text" class="form-control" name="numpat" id="edit-numpat" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit-numeroControle" class="form-label">Número de Controle</label>
                        <input type="text" class="form-control" name="numeroControle" id="edit-numeroControle" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit-descricao" class="form-label">Descrição</label>
                        <input type="text" class="form-control" name="descricao" id="edit-descricao" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit-carga" class="form-label">Carga</label>
                        <input type="text" class="form-control" name="carga" id="edit-carga" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit-observacao" class="form-label">Observação</label>
                        <textarea class="form-control" name="observacao" id="edit-observacao"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" name="edit" class="btn btn-primary">Salvar mudanças</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="js/jquery-3.5.1.min.js"></script>
<script src="js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $('.edit-btn').on('click', function() {
        $('#edit-id').val($(this).data('id'));
        $('#edit-numpat').val($(this).data('numpat'));
        $('#edit-numeroControle').val($(this).data('numerocontrole'));
        $('#edit-descricao').val($(this).data('descricao'));
        $('#edit-carga').val($(this).data('carga'));
        $('#edit-observacao').val($(this).data('observacao'));
    });
});
</script>
</body>
</html>
