<?php
include_once 'connection.php';

try {
    // Consulta para selecionar os dados
    $stmt = $pdo->query("SELECT * FROM quadro ORDER BY antiguidade_geral LIMIT 200");
    $pessoas = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
    exit();
}

// Verifique se existe pelo menos uma pessoa
$primeiraPessoa = !empty($pessoas) ? $pessoas[0] : null;
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Quadro de Presença CEM</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <script src="js/jquery-2.1.1.min.js"></script>
    <link href="css/style.css" rel="stylesheet">

<style>
@keyframes pulse {
    0% {
        box-shadow: 0 0 10px rgba(0, 255, 0, 0.5);
    }
    50% {
        box-shadow: 0 0 20px rgba(0, 255, 0, 1);
    }
    100% {
        box-shadow: 0 0 10px rgba(0, 255, 0, 0.5);
    }
}

.pulse {
    animation: pulse 1.5s infinite;
}


</style>


    <style>

        .image-container {
            position: relative;
            width: 100%;
            padding-bottom: 100%;
            border-radius: 50%;
            overflow: hidden;
            border: 5px solid green;
            transition: border-color 0.3s;
            display: inline-block;
            margin: 0;
        }
        .image-container img {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 85%;
            height: 100%;
            object-fit: cover;
            transform: translate(-50%, -50%);
            transition: filter 0.3s;
        }
        .text-overlay {
            position: absolute;
            bottom: 3%;
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            font-size: 1.2em;
            width: 90%;
        }
        .text-overlay div {
            margin: 0px 0;
            font-weight: bold;
            color: black;
        }
        .faded {
            filter: grayscale(80%) brightness(0.5);
        }
        .faded .text-overlay div {
            color: black;
        }
        .grey-border {
            border-color: gray !important;
        }
        .row {
            margin-right: 0;
            margin-left: 0;
        }

        .col-xs-1 {
            width: 12.5%; /* 100% / 7 = 14.2857% para 7 colunas */
        }

    </style>
    <style>
          #minhaDiv {
              border: 1px solid transparent; /* Borda invisível para contornar o texto */
              padding: 1px; /* Espaçamento interno */
              box-shadow: 0 0 1px rgba(255, 255, 255, 0.8); /* Sombra suave */
              border-radius: 1px; /* Bordas arredondadas */
              background-color: rgba(0, 0, 0, 0.5); /* Fundo transparente para destacar a sombra */
              color: white; /* Cor da fonte */
              font-size: 12px; /* Tamanho da fonte reduzido */
          }
      </style>

</head>

<body>
  </div>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 text-center">
            <h1 class="title" style="font-size: 5em;">COMANDO DO 7º DISTRITO NAVAL</h1>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="row">
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-8 text-center">
                            <img src="images/mb.png" height="249">
                        </div>
                        <div class="col-md-4 text-center"></div>
                    </div>
                </div>
                <div class="col-md-4 text-center">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <?php if ($primeiraPessoa): ?>




                                <div class="image-container <?php echo $primeiraPessoa['presenca'] == 0 ? 'faded' : ''; ?>" onclick="togglePresence(this, <?php echo $primeiraPessoa['presenca']; ?>, <?php echo $primeiraPessoa['id']; ?>)">
                                    <img onerror="this.src='images/imagem.png';" src="<?php echo htmlspecialchars($primeiraPessoa['imagem']); ?>">
                                    <div class="text-overlay">
                                        <div id="minhaDiv"><?php echo htmlspecialchars($primeiraPessoa['posto']); ?> <?php echo htmlspecialchars($primeiraPessoa['corpo']); ?></div>
                                        <div id="minhaDiv"><?php echo str_replace(' ', '<br/>', htmlspecialchars($primeiraPessoa['nome'])); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-2"></div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <img src="images/brasao.png"  height="249">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br/><br/>









    <div class="row">
        <div class="col-md-12">
            <div class="row">
                <?php
                $count = 0; // Contador para controlar o número de pessoas por linha
                foreach ($pessoas as $index => $pessoa):
                    if ($index == 0) continue; // Ignora o primeiro índice
                    if ($count % 8 == 0): // Inicia uma nova linha a cada 7 pessoas
                        if ($count > 0) echo '</div>'; // Fecha a linha anterior, se não for a primeira
                        echo '<div class="row">'; // Abre uma nova linha
                    endif;
                ?>
                    <div class="col-xs-1 text-center" style="padding: 0;"> <!-- 7 colunas por linha -->
                          <div class="image-container <?php echo ($pessoa['presenca'] == 0 ? 'faded' : 'pulse'); ?>" onclick="togglePresence(this, <?php echo $pessoa['presenca']; ?>, <?php echo $pessoa['id']; ?>)">

                            <img onerror="this.src='images/imagem.png';" src="<?php echo htmlspecialchars($pessoa['imagem']); ?>">
                            <div class="text-overlay">
                                <div id="minhaDiv"><?php echo htmlspecialchars($pessoa['posto']); ?> <?php echo htmlspecialchars($pessoa['corpo']); ?></div>
                                <div id="minhaDiv"><?php echo str_replace(' ', '<br/>', htmlspecialchars($pessoa['nome'])); ?></div>
                            </div>
                        </div>
                    </div>
                <?php
                    $count++; // Incrementa o contador
                endforeach;
                if ($count > 0) echo '</div>'; // Fecha a última linha, se necessário
                ?>
            </div>
        </div>
    </div>


</div>

<script>
function togglePresence(container, presence, id) {
    const img = container.querySelector('img');

    if (presence === 0) {
        // Muda para "Chegou a Bordo"
        updatePresence(id, 1, img, container); // 1 para "Chegou a Bordo"
    } else {
        // Muda para "Baixou Terra"
        updatePresence(id, 0, img, container); // 0 para "Baixou Terra"
    }
}

function updatePresence(id, newPresence, img, container) {
    $.ajax({
        url: 'update_presence.php',
        type: 'POST',
        data: { id: id, presence: newPresence },
        success: function(response) {
            // Altera a classe da imagem e do container
            img.classList.toggle('faded', newPresence === 0); // Aplica a classe faded se a nova presença for 0
            container.classList.toggle('grey-border', newPresence === 0); // Altera a borda se necessário
            alert(response);
        },
        error: function(xhr, status, error) {
            alert('Erro ao atualizar a presença: ' + error);
        }
    });
}

// Verifica o estado de presença a cada 30 segundos
setInterval(function() {
    $.ajax({
        url: 'check_presence.php', // Arquivo que verifica o estado no banco de dados
        type: 'GET',
        success: function(data) {
            // Atualiza o estado das imagens com base na resposta
            const pessoas = JSON.parse(data);
            pessoas.forEach(function(pessoa) {
                const container = document.querySelector(`[data-id="${pessoa.id}"]`);
                if (container) {
                    const img = container.querySelector('img');
                    const newPresence = pessoa.presenca;
                    img.classList.toggle('faded', newPresence === 0);
                    container.classList.toggle('grey-border', newPresence === 0);
                }
            });
        },
        error: function(xhr, status, error) {
            console.error('Erro ao verificar presença: ' + error);
        }
    });
}, 2000); // 2 segundos
</script>
</body>
</html>
