<?php
include_once('header.php');
require_once "connection.php";
include_once('nav.php');

?>
<html>
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport">
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <script type="text/javascript" src="js/jquery/jquery-3.3.1.min.js"></script>
  <script type="text/javascript" src="js/bootstrap/js/popper.min.js"></script>
  <script type="text/javascript" src="js/bootstrap/js/bootstrap.min.js"></script>
  <script src="js/jquery.min.js"></script>
  <script src="js/jquery.tablesorter.min.js"></script>
  <script src="js/bootstrap.bundle.min.js"></script>
  <style>
    .date-red {
      background-color: #ffcccc; /* Vermelho claro */
    }
    body{
      padding-top: 88px;
    }
  </style>
  <title>Reação de Bordos</title>
</head>
<body>
<div class="container-fluid">
  <p>Lista de Usuários do SCORE: <input type="text" id="myInput" placeholder="Buscar usuários..."></p>
  <table class="table table-striped table-bordered" id="myTable">
    <thead>
      <tr>
        <th>POSTO/GRAD</th>
        <th>CORPO/QUADRO</th>
        <th>NIP/CPF</th>
        <th>NOME</th>
        <th>ADIDO</th>
        <th>PORTARIA</th>
        <th>Ação</th>
      </tr>
    </thead>
    <tbody>
      <?php
      // Query para selecionar os usuários
      $sql10 = 'SELECT * FROM "public"."adidos";';
      $stmte10 = $pdo->query($sql10);
      while($row = $stmte10->fetch(PDO::FETCH_ASSOC)){
        echo "<tr>";
        echo "<td>" . $row['pg'] . "</td>";
        echo "<td>" . $row['ESP'] . "</td>";
        echo "<td>" . $row['NIP'] . "</td>";
        echo "<td>" . $row['NOME'] . "</td>";
        echo "<td>" . $row['SETOR'] . "</td>";
        echo "<td>" . $row['PORTARIA'] . "</td>";
        echo "<td><button class='btn btn-primary edit-btn' data-id='" . $row['id'] . "' data-pg='" . $row['pg'] . "' data-esp='" . $row['ESP'] . "' data-nip='" . $row['NIP'] . "' data-nome='" . $row['NOME'] . "' data-setor='" . $row['SETOR'] . "' data-portaria='" . $row['PORTARIA'] . "'>Editar</button></td>";
        echo "</tr>";
      }
      ?>
    </tbody>
  </table>
</div>

<!-- Modal de Edição -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editModalLabel">Editar Usuário</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="editForm">
          <div class="form-group">
            <label for="editPg">POSTO/GRAD</label>
            <input type="text" class="form-control" id="editPg" name="pg">
          </div>
          <div class="form-group">
            <label for="editEsp">CORPO/QUADRO</label>
            <input type="text" class="form-control" id="editEsp" name="esp">
          </div>
          <div class="form-group">
            <label for="editNip">NIP/CPF</label>
            <input type="text" class="form-control" id="editNip" name="nip">
          </div>
          <div class="form-group">
            <label for="editNome">NOME</label>
            <input type="text" class="form-control" id="editNome" name="nome">
          </div>
          <div class="form-group">
            <label for="editSetor">SETOR</label>
            <input type="text" class="form-control" id="editSetor" name="setor">
          </div>
          <div class="form-group">
            <label for="editPortaria">PORTARIA</label>
            <input type="text" class="form-control" id="editPortaria" name="PORTARIA">
          </div>
          <input type="hidden" id="editId" name="id">
          <button type="submit" class="btn btn-primary">Salvar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function(){
  // Adiciona funcionalidade de busca
  $("#myInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tbody tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });

  // Adiciona funcionalidade de ordenação
  $("#myTable").tablesorter();

  // Manuseio do botão de edição
  $(".edit-btn").on("click", function(){
    var id = $(this).data("id");
    var pg = $(this).data("pg");
    var esp = $(this).data("esp");
    var nip = $(this).data("nip");
    var nome = $(this).data("nome");
    var setor = $(this).data("setor");
    var portaria = $(this).data("portaria");

    $("#editId").val(id);
    $("#editPg").val(pg);
    $("#editEsp").val(esp);
    $("#editNip").val(nip);
    $("#editNome").val(nome);
    $("#editSetor").val(setor);
    $("#editPortaria").val(portaria);

    $("#editModal").modal("show");
  });

  // Manuseio do formulário de edição
  $("#editForm").on("submit", function(event){
    event.preventDefault();
    var formData = $(this).serialize();
    console.log("Form Data: ", formData); // Adiciona um console.log para verificar os dados do formulário

    $.ajax({
      url: 'update_adidos.php', // arquivo PHP que processará a atualização
      type: 'POST',
      data: formData,
      success: function(response){
        console.log("Response: ", response); // Adiciona um console.log para verificar a resposta do servidor
        // Atualize a linha da tabela com os novos dados
        location.reload();
      },
      error: function(jqXHR, textStatus, errorThrown) {
        console.log("Erro: ", textStatus, errorThrown); // Adiciona um console.log para verificar se há erros
      }
    });
  });
});
</script>

<?php include_once('footer.php');?>
</body>
</html>
