<?php
// Verifica se o formulário foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verifica se o parâmetro "fileToDelete" foi enviado
    if (isset($_POST['fileToDelete'])) {
        // Caminho para o diretório onde os arquivos estão armazenados
        $path = 'documentos/';

        // Obtém o nome do arquivo a ser deletado do formulário
        $fileToDelete = $_POST['fileToDelete'];

        // Caminho completo do arquivo a ser deletado
        $filePath = $path . $fileToDelete;

        // Verifica se o arquivo existe antes de tentar deletá-lo
        if (file_exists($filePath)) {
            // Tenta deletar o arquivo
            if (unlink($filePath)) {
                // Arquivo deletado com sucesso, redireciona de volta à página inicial
                header("Location: " . $_POST['pagina']); // Redireciona para a página especificada
                exit(); // Encerra o script após o redirecionamento
            } else {
                // Se não for possível deletar o arquivo, exibe uma mensagem de erro
                echo "Erro ao tentar deletar o arquivo.";
            }
        } else {
            // Se o arquivo não existir, exibe uma mensagem de erro
            echo "O arquivo não existe.";
        }
    } else {
        // Se o parâmetro "fileToDelete" não estiver definido, exibe uma mensagem de erro
        echo "Parâmetro 'fileToDelete' não encontrado.";
    }
} else {
    // Se o método de requisição não for POST, exibe uma mensagem de erro
    echo "Método de requisição inválido.";
}
?>
