<?php
// Include the main TCPDF library (search for installation path).
require_once('vendor/tecnickcom/tcpdf/tcpdf.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information (optional)
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Your Name');
$pdf->SetTitle('PDF with Image');
$pdf->SetSubject('Displaying an Image');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);

// Stretching, position and alignment example
$pdf->setXY(110, 200);
$pdf->Image('img/logo.jpg', 15, 140, 75, 113, 'JPG', '', '', true, 300, '', false, false, 1, false, false, false);

//-----------------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_009.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
?>
