<?php
require_once 'vendor/autoload.php';
//require_once 'tcpdf_barcodes_2d.php'; // Inclua o arquivo da classe 2D Barcode
var_dump($_POST);
// Verificar se as variáveis POST estão definidas
if (!isset($_POST['nip']) || !isset($_POST['cpf']) || !isset($_POST['posto_graduacao']) ||
    !isset($_POST['especialidade']) || !isset($_POST['guerra']) || !isset($_POST['nome'])) {
    die('Variáveis POST não foram definidas corretamente.');
}

// Receber as variáveis via POST
$nip = $_POST['nip'];
$cpf = $_POST['cpf'];
$posto_graduacao = $_POST['posto_graduacao'];
$especialidade = $_POST['especialidade'];
$guerra = $_POST['guerra'];
$nome = $_POST['nome'];

// Combinar as variáveis em um único texto para o QR code
$qrcode_text = "NIP: $nip\nCPF: $cpf\nPosto/Graduação: $posto_graduacao\nEspecialidade: $especialidade\nNome de Guerra: $guerra\nNome Completo: $nome";

// Criar o objeto do QR code
$barcodeobj = new TCPDF2DBarcode($qrcode_text, 'QRCODE,H');

// Capturar a saída do QR code em HTML
$qrcode_html = $barcodeobj->getBarcodeHTML(6, 6, 'black');

// Criar uma nova instância do TCPDF
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Definir informações básicas do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Marinha do Brasil');
$pdf->SetTitle('Termo de Responsabilidade Individual');
$pdf->SetSubject('Gerado por TCPDF');
$pdf->SetKeywords('TCPDF, PDF, exemplo, teste');

// Remover cabeçalhos e rodapés padrões
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Definir margens
$pdf->SetMargins(10, 10, 10);
$pdf->SetAutoPageBreak(TRUE, 25);

// Adicionar uma página
$pdf->AddPage();

// Definir o estilo CSS para o conteúdo HTML
$css = '
<style>
    h1, h2, h3 {
        text-align: center;
        margin: 0;
        padding: 0;
        font-size: 12px;
    }
    p {
        text-align: justify;
        margin: 0 0 2px 0; /* Diminuir o espaço entre parágrafos */
        padding: 0;
        font-size: 9px; /* Diminuir tamanho da fonte */
        line-height: 1; /* Diminuir o espaço entre linhas */
    }
</style>
';

// Definir o conteúdo HTML com letras no início de cada parágrafo
$html = $css . '
<h1>MARINHA DO BRASIL</h1>
<h2>COMANDO DO SÉTIMO DISTRITO NAVAL</h2>
<h3>TERMO DE RESPONSABILIDADE INDIVIDUAL</h3>
<p style="text-align: right;">Rio de Janeiro, RJ, 22/06/2024.</p>

<p>' . $qrcode_html . '</p>

<p>Pelo presente instrumento, eu, ' . strtoupper($posto_graduacao) . '-' . strtoupper($especialidade) . ' ' . strtoupper($nome) . ', perante a Marinha do Brasil, doravante denominada MB, na qualidade de usuário do ambiente computacional de propriedade daquela Instituição, declaro estar ciente das Instruções de Segurança das Informações e Comunicações (ISIC) da OM, segundo as quais devo:</p>

<p>a) tratar a informação digital como patrimônio da MB e como um recurso que deva ter seu sigilo preservado, em consonância com a legislação vigente;</p>
<p>b) utilizar as informações disponíveis e os sistemas e produtos computacionais, dos quais a MB é proprietária ou possui o direito de uso, exclusivamente para o interesse do serviço;</p>
<p>c) preservar o conteúdo das informações sigilosas a que tiver acesso, sem divulgá-las para pessoas não autorizadas;</p>
<p>d) não tentar obter acesso à informação cujo grau de sigilo não seja compatível com a minha Credencial de Segurança (CREDSEG) ou que eu não tenha autorização ou necessidade de conhecer;</p>
<p>e) não compartilhar o uso de senha com outros usuários;</p>
<p>f) não me fazer passar por outro usuário usando a sua identificação de acesso e senha;</p>
<p>g) não alterar o endereço de rede ou qualquer outro dado de identificação do microcomputador de meu uso;</p>
<p>h) instalar e utilizar em meu microcomputador somente programas homologados para uso na MB e que este possua as respectivas licenças de uso ou, no caso de programas de domínio público, mediante autorização formal do Oficial de Segurança de Informações e Comunicações (OSIC) da OM;</p>
<p>i) no caso de exoneração, demissão, licenciamento, término de prestação de serviço ou qualquer tipo de afastamento, preservar o conteúdo das informações e documentos sigilosos a que tive acesso e não divulgá-los para pessoas não autorizadas;</p>
<p>j) guardar segredo das minhas autenticações de acesso (senhas) utilizadas no ambiente computacional da OM, não cedendo, não transferindo, não divulgando e não permitindo o seu conhecimento por terceiros;</p>
<p>k) não utilizar senha com sequência fácil ou óbvia de caracteres que facilite a sua descoberta e não escrever a senha em lugares visíveis ou de fácil acesso;</p>
<p>l) utilizar, ao me afastar momentaneamente da minha estação de trabalho, descanso de tela “screen saver” protegido por senha, a fim de evitar que alguém possa ver as informações que estejam disponíveis na tela do computador;</p>
<p>m) ao me ausentar do local de trabalho, momentaneamente ou ao término de minhas atividades diárias, certificar-me de que a sessão aberta no ambiente computacional com minha identificação foi fechada e as informações que exigem sigilo foram adequadamente salvaguardadas;</p>
<p>n) seguir as orientações da área de informática da OM relativas à instalação, à manutenção e ao uso adequado dos equipamentos, dos sistemas e dos programas do ambiente computacional;</p>
<p>o) comunicar imediatamente ao meu superior hierárquico e ao Oficial de Segurança das Informações e Comunicações (OSIC) da OM a ocorrência de qualquer evento que implique ameaça ou impedimento de cumprir os procedimentos de segurança estabelecidos;</p>
<p>p) responder, perante a MB, as auditorias e ao Oficial de Segurança das Informações e Comunicações (OSIC) da OM, por acessos, tentativas de acessos ou uso indevido da informação digital, realizados com a minha identificação ou autenticação;</p>
<p>q) não praticar quaisquer atos que possam afetar o sigilo ou a integridade da informação;</p>
<p>r) estar ciente de que toda informação digital armazenada e processada no ambiente computacional da OM pode ser auditada, como no caso de páginas informativas “sites” visitadas por mim;</p>
<p>s) não transmitir, copiar ou reter arquivos contendo textos, fotos, filmes ou quaisquer outros registros que contrariem a moral, os bons costumes e a legislação vigente;</p>
<p>t) não transferir qualquer tipo de arquivo que pertença à MB para outro local, seja por meio magnético ou não, exceto no interesse do serviço e mediante autorização da autoridade competente;</p>
<p>u) estar ciente de que o processamento, o trâmite e o armazenamento de arquivos que não sejam de interesse do serviço são proibidos no ambiente computacional da OM;</p>
<p>v) estar ciente de que a MB poderá auditar os arquivos em trâmite ou armazenados nos equipamentos do ambiente computacional da OM sob meu uso ou responsabilidade;</p>
<p>w) estar ciente de que o correio eletrônico é de uso exclusivo para o interesse do serviço e qualquer correspondência eletrônica originada ou retransmitida no ambiente computacional da OM deve obedecer a este preceito; e</p>
<p>x) estar ciente de que a MB poderá auditar as correspondências eletrônicas originadas ou retransmitidas por mim no ambiente computacional da OM.</p>

<p>Desta forma, estou ciente da minha responsabilidade pelas consequências decorrentes da não observância do acima exposto e da legislação vigente.</p>

<p>GERADO MANUALMENTE ___________________________<br>
SO-EP PABLO</p>

<p style="text-align: center;">Powered by TCPDF (www.tcpdf.org)</p>
';

// Escrever o conteúdo HTML no PDF
$pdf->writeHTML($html, true, false, true, false, '');

// Fechar e gerar o PDF
$pdf->Output('Gerador_de_TRET.pdf', 'I'); // 'I' para abrir no navegador, 'D' para download direto
?>
