<?php
ob_start(); // Inicia o buffer de saída
require_once('vendor/autoload.php');
require_once('vendor/tecnickcom/tcpdf/tcpdf.php');
require_once('connection.php');
use TCPDF;

// Obter a data atual por extenso em português
setlocale(LC_TIME, 'pt_BR.UTF-8');
$data_atual = strftime('%d de %B de %Y');

// Criar uma classe personalizada para o cabeçalho e rodapé
class MYPDF extends TCPDF {

    public function __construct() {
        parent::__construct();
        $this->AddFont('arial', '', 'arial.php');
    }

    // Cabeçalho personalizado
    public function Header() {
        $html = 'Anexo <u>G</u>, da OI nº 50-02B, do Com7ºDN.';
        $this->SetFont('arial', '', 10);
        $this->writeHTMLCell(0, 10, '', '', $html, 0, 1, 0, true, 'R', true);
        $this->Ln(5); // Espaço após o cabeçalho
        //$this->writeHTML("<hr>", true, false, false, false, ''); //Criar linha do cabeçalho
    }

    // Rodapé personalizado
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('arial', '', 10);
        $this->Cell(0, 10, '- G-' . $this->getAliasNumPage() . ' -', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Receber dados via POST
$nip = $_POST['nip'];
$cpf = $_POST['cpf'];
$posto_graduacao = strtoupper($_POST['posto_graduacao']);
$especialidade = strtoupper($_POST['especialidade']);
$guerra = strtoupper($_POST['guerra']);
$nome = strtoupper($_POST['nome']);

if (in_array($posto_graduacao, ['AE', 'VA', 'CA', 'CMG', 'CF', 'CC', 'CT', '1T', '2T', 'GM'])) {
    $posto_especialidade = $posto_graduacao . "(" . $especialidade . ")";
} else {
    $posto_especialidade = $posto_graduacao . "-" . $especialidade;
}

// Verificar e inserir na tabela tripulação
try {
    // Verificar se o NIP existe
    $query = "SELECT * FROM tripulacao WHERE nip = :nip";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':nip', $nip);
    $stmt->execute();
    $result = $stmt->fetch();

    /*if ($result == NULL) {
      $_SESSION['message'] = "Erro ao criar o diretório de destino.";
      header('Location: tri.htm');
      exit;
    }
    */
    if (!$result) {
        // Se não encontrou pelo NIP, verificar pelo CPF
        $query = "SELECT * FROM tripulacao WHERE cpf = :cpf";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cpf', $cpf);
        $stmt->execute();
        $result = $stmt->fetch();

        if (!$result) {
            // Se não encontrou pelo CPF, inserir novo registro
            $query = "INSERT INTO tripulacao (nip, pg, esp, nome, ativo, cpf) VALUES (:nip, :pg, :esp, :nome, 2, :cpf)";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':pg', $posto_graduacao);
            $stmt->bindParam(':esp', $especialidade);
            $stmt->bindParam(':nome', $nome);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        } else {
            // Se encontrou pelo CPF, atualizar o NIP
            $query = "UPDATE tripulacao SET nip = :nip WHERE cpf = :cpf";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        }
    }
} catch (PDOException $e) {
    // Exibir erros de banco de dados antes de gerar o PDF
    die('Erro: ' . $e->getMessage());
}

// Criar novo documento PDF
$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Definir informações do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('Gerador TRI - Com7ºDN');

// Remover cabeçalho/rodapé padrão
$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

// Definir fonte monoespaçada padrão
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Definir margens conforme a ABNT
$pdf->SetMargins(30, 30, 20);  // Esquerda: 3 cm, Superior: 3 cm, Direita: 2 cm
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(20);

// Definir quebra automática de página
$pdf->SetAutoPageBreak(TRUE, 20);  // Inferior: 2 cm

// Definir fator de escala da imagem
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Adicionar uma página
$pdf->AddPage();

// Inserir a imagem
$pdf->Image('img/logo.jpg', 55, 17, 20, 20, 'JPG', '', 'T', true, 300, 'C', false, false, 0, false, false, false);

// Ajustar a posição para os títulos
$pdf->SetY(37);  // Ajustar a linha para posicionar abaixo da imagem
$pdf->Ln(3);
// Títulos
$pdf->SetFont('arial', 'B', 12);
$pdf->Cell(0, 5, 'MARINHA DO BRASIL', 0, 1, 'C');
$pdf->Cell(0, 5, 'COMANDO DO 7º DISTRITO NAVAL', 0, 1, 'C');
$pdf->Cell(0, 5, 'DEPARTAMENTO DE TECNOLOGIA DA INFORMAÇÃO', 0, 1, 'C');
$pdf->writeHTML('<br><br><b>FORMULÁRIO DE ACESSO À INTERNET/ZIMBRA</b>', true, false, false, false, 'C');
$pdf->writeHTML('<hr style="height:2px">', true, false, false, false, '');
$pdf->Ln(-6);
$pdf->writeHTML('<b>( )Inclusão ( )Alteração</b>', true, false, false, false, 'C');

// Definir estilo para o QR code
$pdf->SetXY(5, 10);
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // largura de um módulo em pontos
    'module_height' => 1 // altura de um módulo em pontos
);
$pdf->write2DBarcode('Pelo presente instrumento, eu, perante a', 'QRCODE,L', 5, 5, 50, 50, $style, 'N'); // posição e tamanho ajustados

// Mover para a próxima linha
$pdf->Ln(25);

// Definir fonte de volta ao normal
$pdf->SetFont('arial', '', 12);

// Adicionar o texto
$html = '<p style="text-align:justified;"><table cellspacing="0" cellpadding="3" border="1"><thead>
  <tr>
    <th colspan="2">Usuário da Rede (NIP):</th>
  </tr></thead>
  <tbody><tr>
    <td colspan="2">Nome Completo:</td>
  </tr>
  <tr>
    <td width="75%">Nome de guerra/Posto/Graduação:</td>
    <td width="25%">Setor:</td>
  </tr>
  <tr>
    <td colspan="2">E-mail:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@marinha.mil.br</td>
  </tr>
  <tr>
    <td colspan="2" height="50">Principais sites que necessita acessar:</td>
  </tr>
  <tr>
    <td colspan="2" height="80">Justificativa do acesso:</td>
  </tr>
  <tr>
    <td colspan="2" style="font-size:10vw">Extrato da DGMM 0540 – Normas de Tecnologia da informação da MB (3ª revisão)<br>5.4.1 – Segurança<br><i>“Uma vez interligada à Internet, a MB tem, virtualmente, acesso a diversas informações contidas em redes de  computadores em todo o mundo, mas a recíproca também é verdadeira. Portanto, é necessário implantar medidas de segurança a fim de controlar esse acesso, proveniente tanto de ambientes externos à RECIM quanto daqueles originados a partir da RECIM. Tais medidas implicam, por exemplo, em seleção parcimoniosa e criteriosa do pessoal com direito à utilização da Internet e o uso de dispositivos e de procedimentos operacionais de segurança, para proteção da RECIM e para a detecção de potenciais ameaças externas”.</i><br>5.11 – Uso da Internet<br><i>“O acesso à Internet pelo pessoal da MB por meio da RECIM tem como regra o bom senso. Isto porque não é viável estabelecer normas rígidas quanto aos sítios que se pode ou não ter acesso, considerando a diversidade de informações sob várias nomenclaturas e a evolução do interesse da MB em informações disponibilizadas na Internet. Alguns procedimentos, evidentemente, não são válidos, inclusive do ponto de vista técnico, pois trazem prejuízo ao tráfego das informações de maior utilidade e prioridade. Assim sendo, é proibido acessar sítios contendo matéria atinente a relacionamentos não profissionais, utilizar-se de quaisquer tipos de mecanismos que permitam a troca de mensagens em tempo real com usuários externos à RECIM – (CHAT), bem como acessar páginas de conteúdo considerado impróprio. A DCTIM e o CTIM tem capacidade de monitorar tais acessos e, ao realizar auditoria, se os detectar, dará conhecimento às OM para as medidas disciplinares cabíveis. Em caso de acesso involuntário, o usuário deverá de imediato, registrar o fato em sua OM, participando-o aos seus superiores… No que diz respeito ao correio eletrônico, não será permitida a utilização de assinatura de listas de discussão de assuntos que não sejam atinentes ao interesse da MB. O CTIM poderá implantar mecanismos para evitar que mensagens provenientes de servidores de listas de discussão sejam recebidas pelos servidores de correio da MB.”</i></td>
  </tr></tbody>
</table></p>
<p style="text-align:right;">Brasília, DF, ' . $data_atual . '.</p>
<p align="center">
<table cellspacing="0" cellpadding="20">
  <tr>
    <td>_________________________<br>Assinatura do Solicitante</td>
    <td>_________________________<br>Assinatura do Encarregado</td>
  </tr>
  <tr>
    <td>_________________________<br>CGS</td>
    <td>_________________________<br>DN-03.1</td>
  </tr>
</table>
</p>
<p>
Para uso do Departamento de Tecnologia da Informação<br>
<table cellspacing="0" cellpadding="5" border="1">
  <theader><tr>
    <th><b>Recurso</b></th>
    <th><b>Data</b></th>
    <th><b>Executor</b></th>
  </tr>
  </theader>
  <tbody>
    <tr>
      <td>Aprovado(S/N):</td>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>
</p>
'
;

$pdf->writeHTML($html, true, false, true, false, '');
ob_end_clean(); // Limpa o buffer de saída e desativa o buffering
// Fechar e gerar o documento PDF
$pdf->Output('tri.pdf', 'I');
?>
