<?php
ob_start(); // Inicia o buffer de saída
require_once('vendor/autoload.php');
require_once('vendor/tecnickcom/tcpdf/tcpdf.php');
require_once('connection.php');
use TCPDF;

// Obter a data atual por extenso em português
setlocale(LC_TIME, 'pt_BR.UTF-8');
$data_atual = strftime('%d de %B de %Y');

// Criar uma classe personalizada para o cabeçalho e rodapé
class MYPDF extends TCPDF {

    public function __construct() {
        parent::__construct();
        $this->AddFont('arial', '', 'arial.php');
    }

    // Cabeçalho personalizado
    public function Header() {
        $html = 'Anexo <u>B</u>, da OI nº 50-02B, do Com7ºDN.';
        $this->SetFont('arial', '', 10);
        $this->writeHTMLCell(0, 10, '', '', $html, 0, 1, 0, true, 'R', true);
        $this->Ln(5); // Espaço após o cabeçalho
        //$this->writeHTML("<hr>", true, false, false, false, ''); //Cria linha do cabeçalho
    }

    // Rodapé personalizado
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('arial', '', 10);
        $this->Cell(0, 10, '- B-' . $this->getAliasNumPage() . ' -', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Receber dados via POST
$nip = $_POST['nip'];
$cpf = $_POST['cpf'];
$posto_graduacao = strtoupper($_POST['posto_graduacao']);
$especialidade = strtoupper($_POST['especialidade']);
$guerra = strtoupper($_POST['guerra']);
$nome = strtoupper($_POST['nome']);

if (in_array($posto_graduacao, ['AE', 'VA', 'CA', 'CMG', 'CF', 'CC', 'CT', '1T', '2T', 'GM'])) {
    $posto_especialidade = $posto_graduacao . "(" . $especialidade . ")";
} else {
    $posto_especialidade = $posto_graduacao . "-" . $especialidade;
}

// Verificar e inserir na tabela tripulação
try {
    // Verificar se o NIP existe
    $query = "SELECT * FROM tripulacao WHERE nip = :nip";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':nip', $nip);
    $stmt->execute();
    $result = $stmt->fetch();

    /*if ($result == NULL) {
      $_SESSION['message'] = "Erro ao criar o diretório de destino.";
      header('Location: tri.htm');
      exit;
    }
    */
    if (!$result) {
        // Se não encontrou pelo NIP, verificar pelo CPF
        $query = "SELECT * FROM tripulacao WHERE cpf = :cpf";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cpf', $cpf);
        $stmt->execute();
        $result = $stmt->fetch();

        if (!$result) {
            // Se não encontrou pelo CPF, inserir novo registro
            $query = "INSERT INTO tripulacao (nip, pg, esp, nome, ativo, cpf) VALUES (:nip, :pg, :esp, :nome, 2, :cpf)";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':pg', $posto_graduacao);
            $stmt->bindParam(':esp', $especialidade);
            $stmt->bindParam(':nome', $nome);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        } else {
            // Se encontrou pelo CPF, atualizar o NIP
            $query = "UPDATE tripulacao SET nip = :nip WHERE cpf = :cpf";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        }
    }
} catch (PDOException $e) {
    // Exibir erros de banco de dados antes de gerar o PDF
    die('Erro: ' . $e->getMessage());
}

// Criar novo documento PDF
$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Definir informações do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('Gerador TRI - Com7ºDN');

// Remover cabeçalho/rodapé padrão
$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

// Definir fonte monoespaçada padrão
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Definir margens conforme a ABNT
$pdf->SetMargins(30, 30, 20);  // Esquerda: 3 cm, Superior: 3 cm, Direita: 2 cm
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(20);

// Definir quebra automática de página
$pdf->SetAutoPageBreak(TRUE, 20);  // Inferior: 2 cm

// Definir fator de escala da imagem
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Adicionar uma página
$pdf->AddPage();

// Inserir a imagem
$pdf->Image('img/logo.jpg', 55, 17, 20, 20, 'JPG', '', 'T', true, 300, 'C', false, false, 0, false, false, false);

// Ajustar a posição para os títulos
$pdf->SetY(37);  // Ajustar a linha para posicionar abaixo da imagem
$pdf->Ln(3);
// Títulos
$pdf->SetFont('arial', 'B', 12);
$pdf->Cell(0, 5, 'MARINHA DO BRASIL', 0, 1, 'C');
$pdf->Cell(0, 5, 'COMANDO DO 7º DISTRITO NAVAL', 0, 1, 'C');
$pdf->Cell(0, 10, 'TERMO DE RECEBIMENTO DE ESTAÇÃO DE TRABALHO', 0, 1, 'C');

// Definir estilo para o QR code
$pdf->SetXY(5, 10);
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // largura de um módulo em pontos
    'module_height' => 1 // altura de um módulo em pontos
);
$pdf->write2DBarcode('Pelo presente instrumento, eu, perante a', 'QRCODE,L', 5, 27, 40, 40, $style, 'N'); // posição e tamanho ajustados

// Mover para a próxima linha
$pdf->Ln(0);

// Definir fonte de volta ao normal
$pdf->SetFont('arial', '', 12);

// Adicionar o texto
$html = '<p style="text-align:right;">Brasília, DF, ' . $data_atual . '.</p>
<p style="text-align:justify;" class="intend">
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pelo presente instrumento, eu, ' . $posto_especialidade . ' ' . $nip . ' ' . $nome . ', perante a Marinha do Brasil, doravante denominada MB, na qualidade de usuário do ambiente computacional de propriedade de Instituição, <b>declaro ter recebido uma estação de trabalho</b>, com as seguintes configurações:<br></p>
    <p><b>I - de identificação:</b><br>
    <table>
    <table cellspacing="0" cellpadding="15" border="1">
    <tr>
        <td width="250"><b>a)</b> endereço IP:</td>
        <td></td>
    </tr>
    <tr>
      <td><b>b)</b> endereço físico na rede (<i>MAC</i>):</td>
      <td></td>
    </tr>
    <tr>
      <td><b>c)</b> nome da máquina:</td>
      <td></td>
    </tr>
    <tr>
      <td><b>d)</b> local:</td>
      <td></td>
    </tr>
    <tr>
      <td><b>e)</b> lacre:</td>
      <td></td>
    </tr>
    </table>
  <p><b>II – de instalação de programas:</b><br>
        a) Sistema Operacional: __________________;<br>
        b) <i>Kaspersky</i>;<br>
        c) <i>LibreOffice</i>;<br>
        d) <i>Orion</i>;<br>
        e) <i>7Zip</i>;<br>
        f) <i>Java</i>;<br>
        g) <i>CCleaner</i>;<br>
        h) <i>Mozilla Firefox</i>;<br>
        j) <i>Chamaeleon</i>; e<br>
        k) <i>Adobe Reader</i>.
    </p>
    <p><b>III - de senha de acesso à máquina (boot)</b>, inicialmente estabelecida pelo Administrador da Rede Local (ADMIN) da OM, sendo agora de meu conhecimento;</p>

    <p><b>IV - de senha de configuração (setup)</b>, de conhecimento exclusivo do ADMIN e a qual não devo tomar conhecimento.</p>

    <p><b>V - de dispositivos de gravação de mídias:</b>
    Caso a máquina possua dispositivos que possibilite gravação em mídias (CD / DVD / Pendrive) será imputada a mim a responsabilidade pelas informações produzidas e armazenadas nas mídias por meio desses dispositivos, seja por mim ou por outrem, devendo cumprir os requisitos afetos a segurança criptológica de tais informações.</p>
    <p class="signature"><b>VI - justificar o uso de portas USB, se for o caso:</b><br>__________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________.</p>
    <p><b>VII - disposições gerais:</b>
    Assim, quaisquer alterações ou inclusões nos dados acima são de minha inteira responsabilidade e devem ser previamente autorizadas pelo OSIC, conforme previsto nas normas de Segurança das Informações da OM.</p>
<p class="intend"><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estou ciente de que o ADMIN (executou / não executou) _______________ a “formatação”</i> prévia dos discos rígidos da referida estação de trabalho e sua correspondente reconfiguração e que, a qualquer momento, e sempre que julgar necessário, poderei solicitar ao ADMIN o auxílio para realização dessa “formatação”, de modo a garantir a configuração padronizada da OM e a inexistência de arquivos ou programas irregulares.</p>
<p class="signature "style="text-align:center;">
_______________________________________<br>
' . $posto_especialidade . ' ' . $nip . ' ' . $guerra . '</p>';

$pdf->writeHTML($html, true, false, true, false, '');
ob_end_clean(); // Limpa o buffer de saída e desativa o buffering
// Fechar e gerar o documento PDF
$pdf->Output('tri.pdf', 'I');
?>
