<?php
ob_start(); // Inicia o buffer de saída
require_once('vendor/autoload.php');
require_once('vendor/tecnickcom/tcpdf/tcpdf.php');
require_once('connection.php');
use TCPDF;

// Obter a data atual por extenso em português
setlocale(LC_TIME, 'pt_BR.UTF-8');
$data_atual = strftime('%d de %B de %Y');

// Criar uma classe personalizada para o cabeçalho e rodapé
class MYPDF extends TCPDF {

    public function __construct() {
        parent::__construct();
        $this->AddFont('arial', '', 'arial.php');
    }

    // Cabeçalho personalizado
    public function Header() {
        $html = 'Anexo <u>A</u>, da OI nº 50-02B, do Com7ºDN.';
        $this->SetFont('arial', '', 10);
        $this->writeHTMLCell(0, 10, '', '', $html, 0, 1, 0, true, 'R', true);
        $this->Ln(5); // Espaço após o cabeçalho
        //$this->writeHTML("<hr>", true, false, false, false, ''); //cria linha do cabeçalho
    }

    // Rodapé personalizado
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('arial', '', 10);
        $this->Cell(0, 10, '- A-' . $this->getAliasNumPage() . ' -', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Receber dados via POST
$nip = $_POST['nip'];
$cpf = $_POST['cpf'];
$posto_graduacao = strtoupper($_POST['posto_graduacao']);
$especialidade = strtoupper($_POST['especialidade']);
$guerra = strtoupper($_POST['guerra']);
$nome = strtoupper($_POST['nome']);

if (in_array($posto_graduacao, ['AE', 'VA', 'CA', 'CMG', 'CF', 'CC', 'CT', '1T', '2T', 'GM'])) {
    $posto_especialidade = $posto_graduacao . "(" . $especialidade . ")";
} else {
    $posto_especialidade = $posto_graduacao . "-" . $especialidade;
}

// Verificar e inserir na tabela tripulação
try {
    // Verificar se o NIP existe
    $query = "SELECT * FROM tripulacao WHERE nip = :nip";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':nip', $nip);
    $stmt->execute();
    $result = $stmt->fetch();

    /*if ($result == NULL) {
      $_SESSION['message'] = "Erro ao criar o diretório de destino.";
      header('Location: tri.htm');
      exit;
    }*/
    if (!$result) {
        // Se não encontrou pelo NIP, verificar pelo CPF
        $query = "SELECT * FROM tripulacao WHERE cpf = :cpf";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cpf', $cpf);
        $stmt->execute();
        $result = $stmt->fetch();

        if (!$result) {
            // Se não encontrou pelo CPF, inserir novo registro
            $query = "INSERT INTO tripulacao (nip, pg, esp, nome, ativo, cpf) VALUES (:nip, :pg, :esp, :nome, 2, :cpf)";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':pg', $posto_graduacao);
            $stmt->bindParam(':esp', $especialidade);
            $stmt->bindParam(':nome', $nome);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        } else {
            // Se encontrou pelo CPF, atualizar o NIP
            $query = "UPDATE tripulacao SET nip = :nip WHERE cpf = :cpf";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        }
    }
} catch (PDOException $e) {
    // Exibir erros de banco de dados antes de gerar o PDF
    die('Erro: ' . $e->getMessage());
}

// Criar novo documento PDF
$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Definir informações do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('Gerador TRI - Com7ºDN');

// Remover cabeçalho/rodapé padrão
$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

// Definir fonte monoespaçada padrão
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Definir margens conforme a ABNT
$pdf->SetMargins(30, 30, 20);  // Esquerda: 3 cm, Superior: 3 cm, Direita: 2 cm
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(20);

// Definir quebra automática de página
$pdf->SetAutoPageBreak(TRUE, 20);  // Inferior: 2 cm

// Definir fator de escala da imagem
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Adicionar uma página
$pdf->AddPage();

// Inserir a imagem
$pdf->Image('img/logo.jpg', 55, 17, 20, 20, 'JPG', '', 'T', true, 300, 'C', false, false, 0, false, false, false);

// Ajustar a posição para os títulos
$pdf->SetY(37);  // Ajustar a linha para posicionar abaixo da imagem
$pdf->Ln(3);
// Títulos
$pdf->SetFont('arial', 'B', 12);
$pdf->Cell(0, 5, 'MARINHA DO BRASIL', 0, 1, 'C');
$pdf->Cell(0, 5, 'COMANDO DO 7º DISTRITO NAVAL', 0, 1, 'C');
$pdf->Cell(0, 10, 'TERMO DE RESPONSABILIDADE INDIVIDUAL', 0, 1, 'C');

// Definir estilo para o QR code
$pdf->SetXY(5, 10);
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // largura de um módulo em pontos
    'module_height' => 1 // altura de um módulo em pontos
);
$pdf->write2DBarcode('Pelo presente instrumento, eu, perante a', 'QRCODE,L', 5, 27, 50, 50, $style, 'N'); // posição e tamanho ajustados

// Mover para a próxima linha
$pdf->Ln(10);

// Definir fonte de volta ao normal
$pdf->SetFont('arial', '', 12);

// Adicionar o texto
$html = '<p style="text-align:right;">Brasília, DF, ' . $data_atual . '.</p>
<p style="text-align:justify;">
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pelo presente instrumento, eu, ' . $posto_especialidade . ' ' . $nip . ' ' . $nome . ', perante a Marinha do Brasil, doravante denominada MB, na qualidade de usuário do ambiente computacional de propriedade de Instituição, declaro estar ciente das normas de segurança da informação da OM, segundo as quais devo:<br>
a) tratar Ê a informação digital como patrimônio da MB e como um recurso que deva ter seu sigilo preservado, em consonância com a legislação vigente;<br>
b) utilizar as informações disponíveis e os sistemas e produtos computacionais, dos quais a MB é proprietária ou possui o direito de uso, exclusivamente para o interesse do serviço;<br>
c) preservar o conteúdo das informações sigilosas a que tiver acesso, sem divulgá-las para pessoas não autorizadas;<br>
d) não tentar obter acesso à informação cujo grau de sigilo não seja compatível com a minha Credencial de Segurança (CREDSEG) ou que eu não tenha autorização ou necessidade de conhecer;<br>
e) não compartilhar o uso de senha com outros usuários;<br>
f) não me fazer passar por outro usuário usando a sua identificação de acesso e senha;<br>
g) não alterar o endereço de rede ou qualquer outro dado de identificação do microcomputador de meu uso;<br>
h) utilizar em meu microcomputador somente programas homologados para uso na MB e que este possua as respectivas licenças de uso ou, no caso de programas de domínio público, mediante autorização formal do Oficial de Segurança da Informação e Comunicações (OSIC) da OM;<br>
i) no caso de exoneração, demissão, licenciamento, término de prestação de serviço ou qualquer tipo de afastamento, preservar o conteúdo das informações e documentos sigilosos a que teve acesso e não divulgá-los para pessoas não autorizadas;<br>
j) guardar segredo das autenticações de acesso (senhas) utilizadas no ambiente computacional da OM, não cedendo, não transferindo, não divulgando e não permitindo o seu conhecimento por terceiros;<br>
k) não utilizar senha com sequência fácil ou óbvia de caracteres que facilite a sua descoberta e não escrever a senha em lugares visíveis ou de fácil acesso;<br>
l) utilizar, ao me afastar momentaneamente da minha estação de trabalho, descanso de tela (screensaver) protegido por senha, a fim de evitar que alguém possa ver as informações que estejam disponíveis na tela do computador;<br>
m) ao me ausentar do local de trabalho, momentaneamente ou ao término de minhas atividades diárias, certificar-me de que a sessão aberta no ambiente computacional com minha identificação foi fechada e as informações que exigem sigilo foram adequadamente salvaguardadas;<br>
n) seguir as orientações do Depto de Tecnologia da Informação da OM relativas à instalação, à manutenção e ao uso adequado dos equipamentos, dos sistemas e dos programas do ambiente computacional;<br>
o) comunicar imediatamente ao meu superior hierárquico e ao OSIC da OM a ocorrência de qualquer evento que implique ameaça ou impedimento de cumprir os procedimentos de segurança estabelecidos;<br>
p) responder, perante a MB, às auditorias e ao OSIC da OM, por acessos, tentativas de acessos ou uso indevido da informação digital que forem realizados com a minha identificação ou autenticação;<br>
q) não praticar quaisquer atos que possam afetar o sigilo ou a integridade da informação;<br>
r) estar ciente de que toda informação digital armazenada e processada no ambiente computacional da OM pode ser auditada, inclusive os sites acessados por mim;<br>
s) não transmitir, copiar ou reter arquivos contendo textos, fotos, filmes ou quaisquer outros registros que contrariem a moral, os bons costumes e a legislação vigente;<br>
t) não transferir qualquer tipo de arquivo que pertença à MB para outro local, seja por meio magnético ou não, exceto no interesse do serviço e mediante autorização da autoridade competente;<br>
u) estar ciente de que o processamento, o trâmite e o armazenamento de arquivos que não sejam de interesse do serviço são proibidos no ambiente computacional da OM;<br>
w) estar ciente de que o correio eletrônico é de uso exclusivo para o interesse do serviço e qualquer correspondência eletrônica originada ou retransmitida no ambiente computacional da OM deve obedecer a este preceito; e<br>
x) estar ciente de que a MB poderá auditar as correspondências eletrônicas originadas ou retransmitidas por mim no ambiente computacional da OM.<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Desta forma, estou ciente da minha responsabilidade pelas consequências decorrentes da não observância do acima exposto e da legislação vigente.<br><br><br></p>
<p style="text-align:center;">
_______________________________________<br>
' . $posto_especialidade . ' ' . $nip . ' ' . $guerra . '</p>';

$pdf->writeHTML($html, true, false, true, false, '');
ob_end_clean(); // Limpa o buffer de saída e desativa o buffering
// Fechar e gerar o documento PDF
$pdf->Output('tri.pdf', 'I');
?>
