<?php
ob_start(); // Inicia o buffer de saída
require_once('vendor/autoload.php');
require_once('vendor/tecnickcom/tcpdf/tcpdf.php');
require_once('connection.php');
use TCPDF;

// Obter a data atual por extenso em português
setlocale(LC_TIME, 'pt_BR.UTF-8');
$data_atual = strftime('%d de %B de %Y');

// Criar uma classe personalizada para o cabeçalho e rodapé
class MYPDF extends TCPDF {

    public function __construct() {
        parent::__construct();
        $this->AddFont('arial', '', 'arial.php');
        $this->AddFont('arialb', 'B', 'arialb.php');
        $this->AddFont('ariali', 'I', 'ariali.php');
    }

    // Cabeçalho personalizado
    public function Header() {
        $html = 'Anexo <u>H</u>, da OI nº 50-02B, do Com7ºDN.';
        $this->SetFont('arial', '', 10);
        $this->writeHTMLCell(0, 10, '', '', $html, 0, 1, 0, true, 'R', true);
        $this->Ln(5); // Espaço após o cabeçalho
    }

    // Rodapé personalizado
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('arial', '', 10);
        $this->Cell(0, 10, '- H-' . $this->getAliasNumPage() . ' -', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Receber dados via POST
$nip = $_POST['nip'];
$cpf = $_POST['cpf'];
$posto_graduacao = strtoupper($_POST['posto_graduacao']);
$especialidade = strtoupper($_POST['especialidade']);
$guerra = strtoupper($_POST['guerra']);
$nome = strtoupper($_POST['nome']);

if (in_array($posto_graduacao, ['AE', 'VA', 'CA', 'CMG', 'CF', 'CC', 'CT', '1T', '2T', 'GM'])) {
    $posto_especialidade = $posto_graduacao . "(" . $especialidade . ")";
} else {
    $posto_especialidade = $posto_graduacao . "-" . $especialidade;
}

// Verificar e inserir na tabela tripulação
try {
    // Verificar se o NIP existe
    $query = "SELECT * FROM tripulacao WHERE nip = :nip";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':nip', $nip);
    $stmt->execute();
    $result = $stmt->fetch();

    if (!$result) {
        // Se não encontrou pelo NIP, verificar pelo CPF
        $query = "SELECT * FROM tripulacao WHERE cpf = :cpf";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cpf', $cpf);
        $stmt->execute();
        $result = $stmt->fetch();

        if (!$result) {
            // Se não encontrou pelo CPF, inserir novo registro
            $query = "INSERT INTO tripulacao (nip, pg, esp, nome, ativo, cpf) VALUES (:nip, :pg, :esp, :nome, 2, :cpf)";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':pg', $posto_graduacao);
            $stmt->bindParam(':esp', $especialidade);
            $stmt->bindParam(':nome', $nome);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        } else {
            // Se encontrou pelo CPF, atualizar o NIP
            $query = "UPDATE tripulacao SET nip = :nip WHERE cpf = :cpf";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':nip', $nip);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->execute();
        }
    }
} catch (PDOException $e) {
    // Exibir erros de banco de dados antes de gerar o PDF
    die('Erro: ' . $e->getMessage());
}

// Criar novo documento PDF
$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Definir informações do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('Gerador TRI - Com7ºDN');

// Remover cabeçalho/rodapé padrão
$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

// Definir fonte monoespaçada padrão
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Definir margens conforme a ABNT
$pdf->SetMargins(30, 30, 20);  // Esquerda: 3 cm, Superior: 3 cm, Direita: 2 cm
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(20);

// Definir quebra automática de página
$pdf->SetAutoPageBreak(TRUE, 15);  // Inferior: 2 cm

// Definir fator de escala da imagem
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Adicionar uma página
$pdf->AddPage();

// Inserir a imagem
$pdf->Image('img/logo.jpg', 55, 15, 20, 20, 'JPG', '', 'T', true, 300, 'C', false, false, 0, false, false, false);

// Ajustar a posição para os títulos
$pdf->SetY(37);  // Ajustar a linha para posicionar abaixo da imagem
$pdf->Ln(3);
// Títulos
$pdf->SetFont('arialb', 'B', 12);
$pdf->Cell(0, 5, 'MARINHA DO BRASIL', 0, 1, 'C');
$pdf->Cell(0, 5, 'COMANDO DO 7º DISTRITO NAVAL', 0, 1, 'C');
$pdf->Cell(0, 7, 'TERMO DE RESPONSABILIDADE INDIVIDUAL PARA USO DE SIGDEM', 0, 1, 'C');

// Definir estilo para o QR code
$pdf->SetXY(5, 10);
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // largura de um módulo em pontos
    'module_height' => 1 // altura de um módulo em pontos
);
$pdf->write2DBarcode('Pelo presente instrumento, eu, perante a', 'QRCODE,L', 5, 5, 50, 50, $style, 'N'); // posição e tamanho ajustados

// Mover para a próxima linha
$pdf->Ln(1);

// Definir fonte de volta ao normal
$pdf->SetFont('arial', '', 12);

// Adicionar o texto
$html = '<br>
<p style="text-align:justify;" class="intend">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pelo presente termo, eu, ' . $posto_especialidade . ' ' . $nip . ' ' . $nome . ', declaro estar ciente das normas de segurança da informação do <b>COMANDO DO 7º DISTRITO NAVAL</b>, perante a Marinha do Brasil, doravante denominada MB, na qualidade de <u>usuário</u> do ambiente computacional SIGDEM de propriedade daquela Instituição, segundo as quais devo:<br>
    a) Tratar a informação digital como patrimônio da MB e como um recurso que deva ter seu sigilo preservado, em consonância com a legislação vigente;<br>
    b) Utilizar as informações disponíveis e os sistemas e produtos computacionais, dos quais a MB é proprietária ou possui o direito de uso, exclusivamente para o interesse do serviço;<br>
    c) Preservar o conteúdo das informações sigilosas a que tiver acesso, sem divulgá-las para pessoas não autorizadas;<br>
    d) Não tentar obter acesso à informação cujo grau de sigilo não seja compatível com a minha Credencial de Segurança (CREDSEG) ou que eu não tenha autorização ou necessidade de conhecer;<br>
    e) Não me fazer passar por outro usuário usando a sua identificação de acesso e senha;<br>
    f) Em caso de exoneração, demissão, licenciamento, término de prestação de serviço ou qualquer tipo de afastamento, preservar o conteúdo das informações e documentos sigilosos a que tive acesso e não divulgá-los para pessoas não autorizadas;<br>
    g) Guardar segredo das minhas autenticações de acesso (senhas) utilizadas no ambiente computacional da OM, não cedendo, não transferindo, não divulgando e não permitindo o seu conhecimento por terceiros;<br>
    h) Comunicar imediatamente ao meu superior hierárquico e ao Oficial de Segurança das Informações Digitais (OSID) da OM a ocorrência de qualquer evento que implique ameaça ou impedimento de cumprir os procedimentos de segurança estabelecidos;<br>
    i) Responder, perante a MB, as auditorias e o Oficial de Segurança da Informação e Comunicações (OSIC) da OM, por acessos, tentativas de acessos ou uso indevido da informação digital que forem realizados com a minha identificação ou autenticação;<br>
    j) Não praticar quaisquer atos que possam afetar o sigilo ou a integridade da informação;<br>
    k) Não transmitir, copiar ou reter arquivos contendo textos, fotos, filmes ou quaisquer outros registros que contrariem a moral, os bons costumes e a legislação vigente; e<br>
    l) Não transferir qualquer tipo de arquivo que pertença à MB para outro local, seja por meio magnético ou não, exceto no interesse do serviço e mediante autorização da autoridade competente;
  <p><b>Desta forma, estou ciente da minha responsabilidade pelas consequências decorrentes da não observância do acima exposto e da legislação vigente.</b><p>
</p>
<p style="text-align:center"><b>FORMULÁRIO DE RECEBIMENTO DE CAIXA SIGDEM</b><br><table cellspacing="0" cellpadding="5" border="1">
    <thead>
        <tr>
            <td vertical-align="top" style="text-align:center;">Nome da OM:<br><b>COM7ºDN</b></td>
            <td vertical-align="top" style="text-align:center;">Nome Completo do Usuário:<br>&nbsp;<br>&nbsp;</td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td vertical-align="top" style="text-align:center;">Posto/Grad/NIP/Nome de Guerra:<br>&nbsp;<br>&nbsp;</td>
            <td>DN: com7dn-</td>
        </tr>
        <tr>
            <td vertical-align="top" style="text-align:center;">Data<br><br>____/____/20__</td>
            <td vertical-align="top" style="text-align:center;">Assinatura do usuário<br><br>______________________________</td>
        </tr>
        <tr>
            <td vertical-align="top" style="text-align:center;" colspan="2">Justificativa para criação / Assunção da caixa postal:<br>&nbsp;<br>&nbsp;</td>
        </tr>
        <tr>
            <td vertical-align="top" style="text-align:center;" colspan="2"><b>Retirada de acesso – Motivo:<br>&nbsp;<br>&nbsp;</b></td>
        </tr>
        <tr>
            <td vertical-align="top" style="text-align:center;"><b>Assinatura do usuário<br><br><br>________________________________</b></td>
            <td vertical-align="top" style="text-align:center;"><b>Data<br><br>____/____/20__</b></td>
        </tr>
        <tr>
            <td vertical-align="top" style="text-align:center;" colspan="2">Assinatura do Encarregado do solicitante<br><br><b>________________________________</b></td>
        </tr>
    </tbody>
</table>
</p>';

$pdf->writeHTML($html, true, false, true, false, '');

$pdf->AddPage();

$html = '<p class="intend">
<table cellspacing="0" cellpadding="5px" border="1">
    <thead>
        <tr>
            <th colspan="2" style="text-align:center;"><b>ATUALIZAÇÃO DO CATÁLOGO TELEFÔNICO</b></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>Posto/Grad/NIP/Nome de Guerra:</td>
            <td>DN: com7dn-</td>
        </tr>
        <tr>
          <td colspan="2" style="font-size:11vw" style="text-align:justify;"><b>O Depto de TI (Responsável p/ Catalogo Telefônico)</b> deverá conferir a Função que o militar assumirá em seu respectivo DN, alterar a Pessoa do militar no Catálogo Telefônico, lançar a Função com o seu referido código no campo “Nome da Função que exercerá” abaixo e se identificar e rubricar.<br>
            <b>Obs1:</b> Quando o militar passar a função que exerce ou for desligado do Com7ºDN, deverá ser alterada a Pessoa do militar no Catálogo Telefônico deixando somente a palavra VAGO nos campos nome e sobrenome e o fato deverá ser comunicado no Depto TI para o devido bloqueio do serviço de SIGDEM.<br>
            <b>Obs2:</b> Quando o militar for promovido, deverá ser alterado o Posto/Graduação no Catálogo Telefônico e o fato deverá ser comunicado ao Depto TI via ramal 1441 para as devidas alterações no SIGDEM.<br>
            <b>Obs3:</b> Quando o militar assumir outra caixa ou função no mesmo Departamento ou Sessão informar previamente ao Depto TI.</td>
        </tr>
        <tr>
            <td style="text-align:center;">Nome da Função que exercerá:</td>
            <td style="font-size:10.5vw" style="text-align:center;">Assinatura do <b>DN-53</b> (Responsável p/ Catalogo Telefônico)

            <br><br><br>________________________________
            </td>
        </tr>
        <tr>
            <td colspan="2">A <b>Central Telefônica (DN-53)</b> deverá conferir as categorias dos ramais, alterar o Telefone
              no Catálogo Telefônico, lançar no “Telefone/Ramal” e se identificar e rubricar.
            </td>
        </tr>
        <tr>
            <td style="text-align:center;">Telefone/Ramal:</td>
            <td style="text-align:center;">Assinatura da Central Telefônica
            <br>_______________________________</td>
        </tr>
        <tr>
            <td colspan="2" style="text-align:center;">Assinatura do Encarregado do solicitante<br><br>________________________________</td>
        </tr>
    </tbody>
</table>
</p>
<p class="intend" style="text-align:center;">
  <table cellspacing="4" cellpadding:"2">
  <tr>
    <td>________________________________<br>Assinatura do Resp. p/ atualização no Departamento Tecnologia de Informação</td>
    <td>________________________________<br>Chefe do Departamento de Tecnologia de Informação</td>
  </tr>
  </table>
</p>';

$pdf->writeHTML($html, true, false, true, false, '');
ob_end_clean(); // Limpa o buffer de saída e desativa o buffering
// Fechar e gerar o documento PDF
$pdf->Output('tri.pdf', 'I');
?>
