<?php
require 'vendor/autoload.php';

use Zxing\QrReader;

// Função para converter páginas do PDF para imagem usando Imagick
function pdfToImages($pdfPath) {
    $imagick = new Imagick();
    $imagick->readImage($pdfPath);
    $images = [];

    foreach ($imagick as $index => $page) {
        $page->setImageFormat('png');
        $images[] = $page->getImageBlob();
    }

    return $images;
}

// Função para ler o QR code de uma imagem
function readQrCodeFromImageBlob($imageBlob) {
    // Salva a imagem em um arquivo temporário
    $tempImagePath = tempnam(sys_get_temp_dir(), 'qr_') . '.png';
    file_put_contents($tempImagePath, $imageBlob);

    // Lê o QR code da imagem
    $qrcode = new QrReader($tempImagePath);
    $text = $qrcode->text();

    // Remove o arquivo temporário
    unlink($tempImagePath);

    return $text;
}

// Caminho para o arquivo PDF
$pdfPath = 'upload/tri.pdf';

// Converte as páginas do PDF para imagens
$imageBlobs = pdfToImages($pdfPath);

if (empty($imageBlobs)) {
    echo "Nenhuma imagem encontrada no PDF.";
    exit;
}

// Itera sobre as imagens para encontrar o QR code
$decodedText = null;
foreach ($imageBlobs as $imageBlob) {
    $text = readQrCodeFromImageBlob($imageBlob);
    if ($text) {
        $decodedText = $text;
        break;
    }
}

// Exibe o texto decodificado
if ($decodedText) {
    echo "Texto decodificado do QR code: " . $decodedText;
} else {
    echo "Nenhum QR code encontrado nas páginas do PDF.";
}
?>
