<?php
// Conexão com o banco de dados
require "connection.php";

session_start();
$nip = $_POST["nip"];
function sanitizarNIP($nip) {
    return str_replace(".", "", $nip);
}
$login = sanitizarNIP($nip);
$senha = $_POST["senha"];

// Usuário não forneceu a senha ou o login
if (!$login || !$senha) {
    echo ("<SCRIPT LANGUAGE='JavaScript'>
window.alert('Você deve digitar seu NIP e login!')
window.location.href='index.html';</SCRIPT>");
    exit;
}

try {
    $sql = "SELECT
	operadores.*,
	grau_acesso.*
FROM
	operadores
	INNER JOIN
	grau_acesso
	ON
		id_operador = id
WHERE
	nip = :login";
    $stmte = $pdo->prepare($sql);
    $stmte->bindParam(':login', $login);
    $stmte->execute();
    $total = $stmte->rowCount();
} catch (PDOException $e) {
    echo $e->getMessage();
    exit;
}

// Caso o usuário tenha digitado um login válido o número de linhas será 1..
if ($total) {
    // Obtém os dados do usuário, para poder verificar a senha e passar os demais dados para a sessão
    $dados = $stmte->fetch(PDO::FETCH_OBJ);

    // Verifica a senha
    if (password_verify($senha, $dados->senha)) {
        // TUDO OK! Agora, passa os dados para a sessão e redireciona o usuário
        $_SESSION["id"] = $dados->id_operador;
        $_SESSION["nip"] = $dados->nip;
        $_SESSION["nome"] = $dados->nome;
        $_SESSION["situacao"] = $dados->situacao;
        $_SESSION["pg"] = $dados->pg;
        $_SESSION["tri"] = $dados->tri;
        $_SESSION["tret"] = $dados->tret;
        $_SESSION["score"] = $dados->score;
        $_SESSION["portal"] = $dados->portal;
        $_SESSION["dispositivos"] = $dados->dispositivos;
        $_SESSION["rela"] = $dados->rela;
        $_SESSION["adidos"] = $dados->adidos;
        $_SESSION["operadores"] = $dados->operadores; // Corrigido: $_SESSION["adidos"]
        header("Location: inicial.php");
        exit;
    } else {
        // Se a senha for inválida:
        if (!isset($_SESSION["erro"])) {
            $_SESSION["erro"] = 1;
        } else {
            $_SESSION["erro"]++;
        }

        if ($_SESSION["erro"] > 2) {
            echo ("<SCRIPT LANGUAGE='JavaScript'>
window.alert('Errou a senha 3 vezes, feche o navegador e tente novamente')
window.location.href='index.php';</SCRIPT>");
            exit;
        } else {
            echo ("<SCRIPT LANGUAGE='JavaScript'>
window.alert('Senha inválida')
window.location.href='index.php';</SCRIPT>");
            exit;
        }
    }
} else {
    // Login inválido
    echo ("<SCRIPT LANGUAGE='JavaScript'>
window.alert('O login fornecido por você é inexistente!')
window.location.href='login.php';</SCRIPT>");
    exit;
}
?>
