<?php
include_once('header.php');
require_once "connection.php";
include_once('nav.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" >
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css" >
    <script type="text/javascript" src="js/jquery/jquery-3.3.1.slim.min.js"></script>
    <script type="text/javascript" src="js/bootstrap/js/popper.min.js"></script>
    <script type="text/javascript" src="js/bootstrap/js/bootstrap.min.js"></script>
    <script src="js/jquery.min.js"></script>
    <script src="js/jquery.tablesorter.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <style>
        .date-red {
            background-color: #ffcccc; /* Vermelho claro */
        }
        body{
            padding-top: 88px;
        }
    </style>
    <title>CONSULTA DE DOCUMENTOS SIC</title>
</head>
<body>
<div class="container-fluid">
  <p>Tripulação:   <input type="text" id="myInput" placeholder="Buscar usuários..."></p>
  <table class="table table-striped table-bordered" id="myTable">
    <thead>
      <tr>
        <th>POSTO/GRAD</th>
        <th>ESP</th>
        <th>NIP/CPF</th>
        <th>NOME</th>
        <th>TRI</th>
        <th>TRET</th>
        <th>DISPOSITIVOS</th>
        <th>ZIMBRA</th>
        <th>PORTAL</th>
        <th>SIGDEM</th>
        <th>PAD</th>
        <th>SIC</th>
        <th>COM</th>
        <th>VID</th>
        <th>ARM</th>
        <th>RS</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $sql10 = "SELECT *, setor.setor as setor1, setor.om as om1 FROM tripulacao INNER JOIN setor ON tripulacao.setor = setor.id WHERE setor.om = 'COM7DN' AND ativo = '1' ORDER BY setor1 ASC;";
      $stmte10 = $pdo->query($sql10);
      while($row = $stmte10->fetch(PDO::FETCH_ASSOC)){
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['pg']) . "</td>";
        echo "<td>" . htmlspecialchars($row['esp']) . "</td>";
        echo "<td>" . htmlspecialchars($row['nip']) . "</td>";
        echo "<td>" . htmlspecialchars($row['nome']) . "</td>";

        if (is_null($row['tri'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_tri_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_tri_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">TRI '.htmlspecialchars($row['tri']).' associado ao NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['tri']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }

        if (is_null($row['tret'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_tret_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_tret_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">Associar TRET do NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['tret']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }

        if (is_null($row['disp'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_disp_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_disp_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">Dispositivos do NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['disp']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }

        if (is_null($row['zimbra'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_zimbra_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_zimbra_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">SOLICITAÇÃO de ZIMBRA/INTERNET do NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['zimbra']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }

        if (is_null($row['portal'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_portal_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_portal_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">Associar TRI do NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['portal']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }

        if (is_null($row['sigdem'])) {
          echo '<td class="text-center"><button type="button" disabled class="btn btn-danger">NÃO</button></td>';
        } else {
          echo '<td class="text-center"><button type="button" class="btn btn-success" data-toggle="modal" data-target="#modalExemplo_sigdem_pdf'.$row['id_user'].'">OK</button></td>';
          echo '<div class="modal fade" id="modalExemplo_sigdem_pdf'.$row['id_user'].'" tabindex="-1" role="dialog" aria-labelledby="modalExemploTitulo" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable modal-xl">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalExemploTitulo">Papeleta de SIGDEM do NIP: '. htmlspecialchars($row['nip']) .' NOME: '. htmlspecialchars($row['nome']) .'</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <embed src="'.htmlspecialchars($row['sigdem']).'" frameborder="0" width="100%" height="600px">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>
                  </div>
                </div>
              </div>';
        }



        echo "<td>" . htmlspecialchars($row['pad']) . "</td>";
        echo "<td>" . htmlspecialchars($row['sic']) . "</td>";
        echo "<td>" . htmlspecialchars($row['com']) . "</td>";
        echo "<td>" . htmlspecialchars($row['vid']) . "</td>";
        echo "<td>" . htmlspecialchars($row['arm']) . "</td>";
        echo "<td>" . htmlspecialchars($row['rs']) . "</td>";
        echo "</tr>";
      }
      ?>
    </tbody>
  </table>
</div>

<script>
$(document).ready(function() {
    // Adiciona funcionalidade de busca
    $("#myInput").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#myTable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Adiciona funcionalidade de ordenação
    $("#myTable").tablesorter();

    // Coloca o foco no campo de busca ao carregar a página
    $("#myInput").focus();
});

</script>
<?php include_once('footer.php'); ?>
</body>
</html>
