<?php
require_once "connection.php";
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $pg = $_POST['pg'];
    $esp = $_POST['esp'];
    $nip = $_POST['nip'];
    $nome = $_POST['nome'];
    $setor = $_POST['setor'];

    // Sanitização e validação básica
    if (!empty($id) && !empty($pg) && !empty($esp) && !empty($nip) && !empty($nome) && !empty($setor)) {
        try {
            $sql = "UPDATE tripulacao SET pg = :pg, ESP = :esp, NIP = :nip, NOME = :nome, SETOR = :setor WHERE id_user = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->bindParam(':pg', $pg, PDO::PARAM_STR);
            $stmt->bindParam(':esp', $esp, PDO::PARAM_STR);
            $stmt->bindParam(':nip', $nip, PDO::PARAM_STR);
            $stmt->bindParam(':nome', $nome, PDO::PARAM_STR);
            $stmt->bindParam(':setor', $setor, PDO::PARAM_STR);

            if ($stmt->execute()) {
                echo json_encode(["status" => "success", "message" => "User updated successfully."]);
            } else {
                echo json_encode(["status" => "error", "message" => "Failed to update user."]);
            }
        } catch (PDOException $e) {
            echo json_encode(["status" => "error", "message" => $e->getMessage()]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "All fields are required."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>
