<?php
require_once 'vendor/autoload.php';

// Verificar se o formulário foi enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Capturar os dados do formulário
    $nip = htmlspecialchars(trim($_POST['nip']));
    $cpf = htmlspecialchars(trim($_POST['cpf']));
    $imeis = $_POST['imeis'];
    $marcas = $_POST['marcaDisps'];
    $modelos = $_POST['modeloDisps'];
    $descricoes = $_POST['descrDisps'];

    // Validar os dados do formulário
    if (strlen($nip) != 8 && strlen($cpf) != 11) {
        echo "O NIP/CPF informado não possui a quantidade correta de dígitos.";
        exit;
    }
    foreach ($imeis as $imei) {
        if (strlen($imei) != 15) {
            echo "O IMEI ou N° SERIAL informado não possui a quantidade correta de dígitos.";
            exit;
        }
    }

    // Criar uma nova instância do TCPDF
    $pdf = new TCPDF();

    // Definir informações do documento
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Nome da Organização');
    $pdf->SetTitle('Declaração de Dispositivo Móvel Particular');
    $pdf->SetSubject('Declaração');
    $pdf->SetKeywords('PDF, declaração, dispositivo móvel');

    // Definir margens
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // Adicionar uma página
    $pdf->AddPage();

    // Conteúdo da declaração
    $html = '<h1 style="text-align: center;">Declaração de Dispositivo Móvel Particular</h1>';
    $html .= '<p><b>NIP:</b> ' . $nip . '</p>';
    $html .= '<p><b>CPF:</b> ' . $cpf . '</p>';
    $html .= '<h2>Dispositivos:</h2>';

    foreach ($imeis as $index => $imei) {
        $marca = htmlspecialchars(trim($marcas[$index]));
        $modelo = htmlspecialchars(trim($modelos[$index]));
        $descricao = htmlspecialchars(trim($descricoes[$index]));
        $html .= '<p><b>IMEI/Nº Série:</b> ' . $imei . '</p>';
        $html .= '<p><b>Marca:</b> ' . $marca . '</p>';
        $html .= '<p><b>Modelo:</b> ' . $modelo . '</p>';
        $html .= '<p><b>Descrição:</b> ' . $descricao . '</p>';
        $html .= '<hr>';
    }

    // Adicionar seção de assinatura
    $html .= '<p style="text-align: center; margin-top: 50px;">______________________________</p>';
    $html .= '<p style="text-align: center;">Assinatura</p>';

    // Adicionar o conteúdo ao PDF
    $pdf->writeHTML($html, true, false, true, false, '');

    // Fechar e enviar o PDF
    $pdf->Output('declaracao_dispositivo_movel.pdf', 'D');
} else {
    echo "Método de requisição inválido.";
}
?>
